#ifndef _DIALOGS_MAIN_H
#define _DIALOGS_MAIN_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ServerDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;

    static HWND StaticFrame_hWnd = NULL;
    static HWND Connections_hWnd = NULL;
    static HWND TotalConnects_hWnd = NULL;
    static HWND Warnings_hWnd = NULL;
    static HWND Errors_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        gbIsServerDialogOpen = true;

        ServerDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1001, "Version");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)TitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        SDI.Menu_hWnd = LoadMenu(MainInstance, MAKEINTRESOURCE(IDR_SERVERDLGMENU));
        SetMenu(xHandle, SDI.Menu_hWnd);

        StaticFrame_hWnd       = GetDlgItem(xHandle, IDC_STATICFRAME);
        SDI.ServerList_hWnd    = GetDlgItem(xHandle, IDC_SERVERLIST);
        Connections_hWnd   = GetDlgItem(xHandle, IDC_CONNECTIONS);
        TotalConnects_hWnd = GetDlgItem(xHandle, IDC_TOTALCONNECTS);
        Warnings_hWnd      = GetDlgItem(xHandle, IDC_WARNINGS);
        Errors_hWnd        = GetDlgItem(xHandle, IDC_ERRORS);

        SDI.StatusBar_hWnd = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Ready", xHandle, 1);

        RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(SDI.ServerList_hWnd, 0, 101, WindowRECT.right, (WindowRECT.bottom-20) - 101, TRUE);
        MoveWindow(StaticFrame_hWnd, 0, 0, WindowRECT.right, 100, TRUE);

        DialogBox(MainInstance, MAKEINTRESOURCE(IDD_SPLASH), xHandle, SplashDialog);

        Set_Long(Connections_hWnd, glConnections);
        Set_Long(TotalConnects_hWnd, glTotalConnects);
        Set_Long(Warnings_hWnd, glWarningCount);
        Set_Long(Errors_hWnd, glErrorCount);

        SetTimer(xHandle, 0, 500, NULL);

        if(gbServerRunning)
        {
            EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_START, MF_GRAYED);
            EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_STOP, MF_ENABLED);
            EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_SETTINGS, MF_GRAYED);
        }
        else{
            EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_START, MF_ENABLED);
            EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_STOP, MF_GRAYED);
            EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_SETTINGS, MF_ENABLED);
        }

        if(gbDebugMode)
            CheckMenuItem(SDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
        else CheckMenuItem(SDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);

        CenterWindow(xHandle);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_TIMER)
    {
        Set_Long(Connections_hWnd, glConnections);
        Set_Long(TotalConnects_hWnd, glTotalConnects);
        Set_Long(Warnings_hWnd, glWarningCount);
        Set_Long(Errors_hWnd, glErrorCount);
        return true;
    }

    if(xMessage == WM_SIZE)
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(SDI.ServerList_hWnd, 0, 101, nWidth, (nHeight-20) - 101, TRUE);
        MoveWindow(SDI.StatusBar_hWnd, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);
        MoveWindow(StaticFrame_hWnd, 0, 0, nWidth, 100, TRUE);

        return TRUE;
    }

    if(xMessage == WM_COMMAND)
    {
        if(wParam == ID_SPECIAL_OPENCONSOLE)
        {
            if(gbConsoleOpen)
                MessageBox(xHandle, "The console is already open.", TitleCaption, MB_TASKMODAL);
            else OpenConsole();
            return TRUE;
        }

        if(wParam == ID_HELP_VERSION)
        {
            char VersionText[128];
            sprintf(VersionText, "%s, Version %s \r\n Built on '%s' at '%s'", TitleCaption, FileVersion, __DATE__, __TIME__);
            MessageBox(xHandle, VersionText, "Application Version", MB_TASKMODAL);
            return TRUE;
        }

        if(wParam == ID_HELP_ABOUT)
        {
            NetLogo(xHandle);
            return true;
        }

        if(wParam == ID_SPECIAL_DEBUGMODE)
        {
            if(gbDebugMode)
            {
                CheckMenuItem(SDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);
                gbDebugMode = false;
            }
            else{
                CheckMenuItem(SDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
                gbDebugMode = true;
            }
            return TRUE;
        }

        if(wParam == ID_SERVER_START)
        {
            StartServer();
            return TRUE;
        }

        if(wParam == ID_SERVER_STOP)
        {
            StopServer();
            return TRUE;
        }

        if(wParam == ID_SERVER_CLOSE)
        {
            gbIsServerDialogOpen = false;
            EndDialog(xHandle,0);
            DestroyWindow(xHandle);
            return TRUE;
        }

        if(wParam == ID_SERVER_SETTINGS)
        {
            PROPSHEETPAGE   psp[5];
            PROPSHEETHEADER psh;

            memset(&psp[0], '\0', sizeof(PROPSHEETPAGE));
            psp[0].dwSize      = sizeof(PROPSHEETPAGE);
            psp[0].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[0].hInstance   = MainInstance;
            psp[0].pszTemplate = MAKEINTRESOURCE(IDD_GENERALTAB);
            psp[0].pszIcon     = NULL;
            psp[0].pszTitle    = "General";
            psp[0].pfnDlgProc  = TabGeneralDialog;
            psp[0].lParam      = 0;
            psp[0].pfnCallback = NULL;
            psp[0].pcRefParent = NULL;

            memset(&psp[1], '\0', sizeof(PROPSHEETPAGE));
            psp[1].dwSize      = sizeof(PROPSHEETPAGE);
            psp[1].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[1].hInstance   = MainInstance;
            psp[1].pszTemplate = MAKEINTRESOURCE(IDD_SECURITYTAB);
            psp[1].pszIcon     = NULL;
            psp[1].pszTitle    = "Security";
            psp[1].pfnDlgProc  = TabSecurityDialog;
            psp[1].lParam      = 0;
            psp[1].pfnCallback = NULL;
            psp[1].pcRefParent = NULL;

            memset(&psp[2], '\0', sizeof(PROPSHEETPAGE));
            psp[2].dwSize      = sizeof(PROPSHEETPAGE);
            psp[2].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[2].hInstance   = MainInstance;
            psp[2].pszTemplate = MAKEINTRESOURCE(IDD_SERVERTAB);
            psp[2].pszIcon     = NULL;
            psp[2].pszTitle    = "Server";
            psp[2].pfnDlgProc  = TabServerDialog;
            psp[2].lParam      = 0;
            psp[2].pfnCallback = NULL;
            psp[2].pcRefParent = NULL;

            memset(&psp[3], '\0', sizeof(PROPSHEETPAGE));
            psp[3].dwSize      = sizeof(PROPSHEETPAGE);
            psp[3].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[3].hInstance   = MainInstance;
            psp[3].pszTemplate = MAKEINTRESOURCE(IDD_WPINDEXDBTAB);
            psp[3].pszIcon     = NULL;
            psp[3].pszTitle    = "WPIndex DB";
            psp[3].pfnDlgProc  = TabWPIndexDialog;
            psp[3].lParam      = 0;
            psp[3].pfnCallback = NULL;
            psp[3].pcRefParent = NULL;

            memset(&psp[4], '\0', sizeof(PROPSHEETPAGE));
            psp[4].dwSize      = sizeof(PROPSHEETPAGE);
            psp[4].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[4].hInstance   = MainInstance;
            psp[4].pszTemplate = MAKEINTRESOURCE(IDD_CLIENTDBSTAB);
            psp[4].pszIcon     = NULL;
            psp[4].pszTitle    = "Client DBS";
            psp[4].pfnDlgProc  = TabClientDBSDialog;
            psp[4].lParam      = 0;
            psp[4].pfnCallback = NULL;
            psp[4].pcRefParent = NULL;

            memset(&psh, '\0', sizeof(PROPSHEETHEADER));
            psh.dwSize      = sizeof(PROPSHEETHEADER);
            psh.dwFlags     = PSH_USEHICON | PSH_PROPSHEETPAGE | PSH_NOAPPLYNOW;
            psh.hwndParent  = xHandle;
            psh.hInstance   = MainInstance;
            psh.hIcon       = LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_MAINICON));
            psh.pszCaption  = "Server Settings";
            psh.nPages      = 5;
            psh.nStartPage  = 0;
            psh.ppsp        = (LPCPROPSHEETPAGE) &psp;
            psh.pfnCallback = NULL;

            PropertySheet(&psh);

            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1001) //- Version (SysMenu Command)
        {
            char VersionText[128];
            sprintf(VersionText, "%s, Version %s \r\n Built on '%s' at '%s'", TitleCaption, FileVersion, __DATE__, __TIME__);
            MessageBox(xHandle, VersionText, "Application Version", MB_TASKMODAL);
            return TRUE;
        }
        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        gbIsServerDialogOpen = false;
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

